// Modules to control application life and create native browser window
const {app, BrowserWindow} = require('electron')
const path = require('path')
//
const ffi = require("ffi-napi");
const ref = require('ref-napi');
const refArray = require('ref-array-napi');

function createWindow () {
  // Create the browser window.
  const mainWindow = new BrowserWindow({
    width: 800,
    height: 600,
    webPreferences: {
      preload: path.join(__dirname, 'preload.js')
    }
  })

  checkDongle()
  // and load the index.html of the app.
  mainWindow.loadFile('index.html')

  // Open the DevTools.
  // mainWindow.webContents.openDevTools()
}

// This method will be called when Electron has finished
// initialization and is ready to create browser windows.
// Some APIs can only be used after this event occurs.
app.whenReady().then(() => {
  createWindow()

  app.on('activate', function () {
    // On macOS it's common to re-create a window in the app when the
    // dock icon is clicked and there are no other windows open.
    if (BrowserWindow.getAllWindows().length === 0) createWindow()
  })
})

// Quit when all windows are closed, except on macOS. There, it's common
// for applications and their menu bar to stay active until the user quits
// explicitly with Cmd + Q.
app.on('window-all-closed', function () {
  if (process.platform !== 'darwin') app.quit()
})

// In this file you can include the rest of your app's specific main process
// code. You can also put them in separate files and require them here.

function checkDongle(){
   var ptrIntType = refArray(ref.types.int32)
   var ptrCharType = refArray(ref.types.char)
   var ret = 0
   const libRockey = new ffi.Library('./dll/Rockey2.dll', {
    'RY2_Open': ['int32', ['int32', 'int32', ptrIntType]],
    'RY2_Close': ['void', ['int32']],
    'RY2_Write':['int32',['int32', 'int32', ptrCharType]],
    'RY2_Read':['int32',['int32', 'int32', ptrCharType]],
    'RY2_Find': ['int32', []]
    })
   
   // 1. Find ROCKEY2
   ret = libRockey.RY2_Find()
   if (ret < 1) {
    console.log('Find 0 ROCKEY2....')
   }
   // 2. Open ROCKEY2
   var ptrHid = ref.alloc(ptrIntType)
   var uid = 0
   var handle = 0
   handle = libRockey.RY2_Open(1, uid, ptrHid)
   if (handle != 0) {
    console.log('Open ROCKEY2 failed....')
   }
   // 3. Write ROCKEY2
   var i = 0
   var ptrInData = new ptrCharType(512)//ref.alloc(ptrCharType)
   for (i=0;i<512; i++){
     ptrInData[i] = 18
   }
   ret = libRockey.RY2_Write(handle, 1, ptrInData)
   if (ret != 0){
     console.log('Write ROCKEY2 failed...')
   }
   //4. Read ROCKEY2
   var ptrOutData = new ptrCharType(512)
   ret = libRockey.RY2_Read(handle, 1, ptrOutData)
   if (ret != 0){
    console.log('Write ROCKEY2 failed...')
   }
   var strData = ''
   for (i =0; i<512; i++){
    strData = strData + ' '+ ptrOutData[i].toString()
   }
   console.log(strData)
   //5. Close ROCKEY2
   libRockey.RY2_Close(handle)
   

}