#include <ApplicationServices/ApplicationServices.h>
#include "rockey2.h"

static OSErr FindApplicationDirectory(short *theVRefNum, long *theParID)
{
	OSErr theErr;
	ProcessSerialNumber thePSN;
	ProcessInfoRec theInfo;
	FSSpec theSpec;
	
	thePSN.highLongOfPSN = 0;
	thePSN.lowLongOfPSN = kCurrentProcess;
	
	theInfo.processInfoLength = sizeof(theInfo);
	theInfo.processName = NULL;
	theInfo.processAppSpec = &theSpec;
	
	/* Find the application FSSpec */
	theErr = GetProcessInformation(&thePSN, &theInfo);
	
	if (theErr == noErr)
	{
		/* Return the folder which contains the application */
		*theVRefNum = theSpec.vRefNum;
		*theParID = theSpec.parID;
	}
	
	return theErr;
}
static OSErr CreateBundleFromFSSpec(FSSpec *theSpec, CFBundleRef *theBundle)
{
	OSErr theErr;
	FSRef theRef;
	CFURLRef theBundleURL;
	
	/* Turn the FSSpec pointing to the Bundle into a FSRef */
	theErr = FSpMakeFSRef(theSpec, &theRef);
	
	/* Turn the FSRef into a CFURL */
	theBundleURL = CFURLCreateFromFSRef(kCFAllocatorSystemDefault, &theRef);
	
	if (theBundleURL != NULL)
	{
		/* Turn the CFURL into a bundle reference */
		*theBundle = CFBundleCreate(kCFAllocatorSystemDefault, theBundleURL);
		
		CFRelease(theBundleURL);
	}
	
	return theErr;
}


CFBundleRef Initialize(CFBundleRef theBundle, FindPtr *find, 
						OpenPtr *open, ClosePtr *close, GenUIDPtr *genUID, 
						ReadPtr *read, WritePtr *write, TramsformPtr *tramsform)
{
	OSErr theErr;
	Boolean isLoaded;
	short theVRefNum;
	long theParID;
	FSSpec theSpec;
//	CFBundleRef theBundle;
	/* Start with no bundle */
	theBundle = NULL;
	
	/* This returns the directory which contains the application */
	theErr = FindApplicationDirectory(&theVRefNum, &theParID);
	
	/* Create the FSSpec pointing to the Bundle */
	if (theErr == noErr)
		theErr = FSMakeFSSpec(theVRefNum, theParID, "\pRockey2.bundle", &theSpec);
	if (theErr !=noErr)
	{
		theErr = FindFolder(kOnSystemDisk,kSystemFolderType,kDontCreateFolder,&theVRefNum,&theParID);
		theErr = FSMakeFSSpec(theVRefNum, theParID,"\p:Library:Rockey:Rockey2.bundle", &theSpec);
	}
	/* Create a bundle reference based on a FSSpec */
	if (theErr == noErr)
		theErr = CreateBundleFromFSSpec(&theSpec, &theBundle);
	
	if ((theErr == noErr) && (theBundle != NULL))
	{
		isLoaded = CFBundleLoadExecutable(theBundle);
		
		if (isLoaded)
		{
			/* Lookup the function in the bundle by name */
			*find = (void *) CFBundleGetFunctionPointerForName(theBundle, CFSTR("RY2_Find"));
			*open = (void *) CFBundleGetFunctionPointerForName(theBundle, CFSTR("RY2_Open"));
			*close = (void *) CFBundleGetFunctionPointerForName(theBundle, CFSTR("RY2_Close"));
			*genUID = (void *) CFBundleGetFunctionPointerForName(theBundle, CFSTR("RY2_GenUID"));
			*read = (void *) CFBundleGetFunctionPointerForName(theBundle, CFSTR("RY2_Read"));
			*write = (void *) CFBundleGetFunctionPointerForName(theBundle, CFSTR("RY2_Write"));
			*tramsform = (void *) CFBundleGetFunctionPointerForName(theBundle, CFSTR("RY2_Transform"));
			
			/* Call the function if it was found */
			if ((*find != NULL)&&(*open != NULL)&&(*close != NULL)&&(*genUID != NULL)&&(*read != NULL)&&(*write != NULL)&&(*tramsform != NULL))
			{
				return theBundle;
			
			/* Dispose of the function pointer to the bundled Mach-O routine */
			}
			CFBundleUnloadExecutable(theBundle);
			
		}
		else
			CFRelease(theBundle);

	}
	return NULL;
}

void Uninitialize(CFBundleRef theBundle)
{
	if(theBundle)
	{
	 	CFBundleUnloadExecutable(theBundle);
		CFRelease(theBundle);
	}
}
