#ifndef _BASSALL_H_
#define _BASSALL_H_

#include <windows.h>
#include <stdio.h>

#include "es_ssl/cryptoki_ext.h"

class CP11TestBase
{
public:
	CP11TestBase(char *libFilePath);
	virtual ~CP11TestBase();

	CK_RV Finalize(void);
	CK_RV Initialize(void);
	void GenerateKey_AES();
	CK_OBJECT_HANDLE GetAesKeyHandle();

	void CreateObject_rsaPub(unsigned char* pN, int lenN, unsigned char* pE, int lenE);
	CK_OBJECT_HANDLE GetRsaPubKeyHandle();
	CK_RV RsaWrapAes(CK_OBJECT_HANDLE rsaPubHandle, CK_OBJECT_HANDLE aesHandle, unsigned char* wrappedKey, CK_ULONG* pWrappedKeyLen);
	
	CK_RV EncrptPkcs8RsaPrivate(CK_OBJECT_HANDLE aesHandle, unsigned char* privatePlain, CK_ULONG pPlainLen, unsigned char* privateEncrypted, CK_ULONG* pEncryptedLen);

	CK_RV AesUnWrapRsa(CK_OBJECT_HANDLE aesHandle,
		CK_BYTE_PTR wrappedKey,
		CK_ULONG wrappedLen,
		CK_OBJECT_HANDLE_PTR pPrivateHanle,
		CK_BYTE_PTR dataN, 
		CK_ULONG lenN, 
		CK_BYTE_PTR dataE, 
		CK_ULONG lenE, 
		CK_BYTE_PTR dataD, 
		CK_ULONG lenD, 
		CK_BYTE_PTR dataP, 
		CK_ULONG lenP, 
		CK_BYTE_PTR dataQ, 
		CK_ULONG lenQ, 
		CK_BYTE_PTR dataDP,
		CK_ULONG lenDP, 
		CK_BYTE_PTR dataDQ,
		CK_ULONG lenDQ, 
		CK_BYTE_PTR dataQP, 
		CK_ULONG lenQP);


protected:
	bool _CheckRV(char *pInfo, CK_RV rv);

protected:
	CK_SESSION_HANDLE m_hSession;
	CK_FUNCTION_LIST_PTR m_p11;
	char m_ucPin[1024];

	CK_SLOT_ID_PTR m_pSlotList;
	HMODULE m_hDll;
	char m_libFileName[MAX_PATH];

	HANDLE m_hStdErr;
	HANDLE m_hStdOut;

public:
	CK_OBJECT_HANDLE m_hKey;

	CK_OBJECT_HANDLE m_hKey_AES;
	CK_OBJECT_HANDLE m_hKey_rsaPub;
	CK_RV SignTest(CK_OBJECT_HANDLE PrivateKeyHandle);
};

#endif // _BASSALL_H_

