/**
 * @file types.h
 * @author weitao@mail.page (Oct 14, 2010) Init version.
 * @author 
 *
 * @brief Type defines.
 * 
 */
#ifndef ES_TYPES_H
#define ES_TYPES_H

typedef unsigned char		u1;
typedef unsigned short		u2;

#if defined(WIN32)
typedef unsigned long		u4;
typedef long				s4;
#else
typedef unsigned int		u4;
typedef unsigned long int       u8;
typedef int				s4;
#endif

typedef char				s1;
typedef short				s2;


#define MAKE2(a, b)      	((u2)(((u1)(a)) | ((u2)((u1)(b))) <<  8))
#define MAKE4(a, b)      	((u4)(((u2)(a)) | ((u4)((u2)(b))) << 16))
#define LO2(l)           	((u2)(l))
#define HI2(l)           	((u2)(((u4)(l) >> 16) & 0xFFFF))
#define LO1(w)           	((u1)(w))
#define HI1(w)           	((u1)(((u2)(w) >>  8) & 0xFF  ))

#if defined(WIN32) || defined(linux) || defined(macintosh)
#define HOST_LITTLE_ENDIAN
#else 
#define HOST_BIG_ENDIAN
#endif

#if !defined HOST_BIG_ENDIAN && !defined HOST_LITTLE_ENDIAN
#error "Please define byte order for target platform."
#endif//byte order

#define REVERSE_ORDER2(x)	(((u2)x & 0xFF00    )>>  8  |		\
							 ((u2)x & 0x00FF    )<<  8  )
							
#define REVERSE_ORDER4(x)	(((u4)x & 0xFF000000)>> 24  |		\
							 ((u4)x & 0x00FF0000)>>  8  |		\
							 ((u4)x & 0x0000FF00)<<  8  |		\
							 ((u4)x & 0x000000FF)<< 24 ) 
/*
	H=host
	BE=Big Endian
	LE=Little Endian
 */


#ifdef HOST_BIG_ENDIAN
inline u2 BE2H(u2 x){return x;}
inline u4 BE2H(u4 x){return x;}

inline u2 H2BE(u2 x){return x;}
inline u4 H2BE(u4 x){return x;}

inline u2 LE2H(u2 x){return REVERSE_ORDER2(x);}
inline u4 LE2H(u4 x){return REVERSE_ORDER4(x);}

inline u2 H2LE(u2 x){return REVERSE_ORDER2(x);}
inline u4 H2LE(u4 x){return REVERSE_ORDER4(x);}
#endif//HOST_BIG_ENDIAN

#ifdef HOST_LITTLE_ENDIAN
inline u2 BE2H(u2 x){return REVERSE_ORDER2(x);}
inline u4 BE2H(u4 x){return REVERSE_ORDER4(x);}

inline u2 H2BE(u2 x){return REVERSE_ORDER2(x);}
inline u4 H2BE(u4 x){return REVERSE_ORDER4(x);}

inline u2 LE2H(u2 x){return x;}
inline u4 LE2H(u4 x){return x;}

inline u2 H2LE(u2 x){return x;}
inline u4 H2LE(u4 x){return x;}
#endif//HOST_LITTLE_ENDIAN

typedef u4 ES_RV;

#define ESR_OK							0x00000000
#define ESR_HOST_MEMORY					0x00000002
#define ESR_SLOT_ID_INVALID				0x00000003
#define ESR_GENERAL_ERROR				0x00000005
#define ESR_ARGUMENTS_BAD				0x00000007
#define ESR_NO_EVENT				    0x00000008
#define ESR_TEMPLATE_INCOMPLETE			0x000000D0
#define ESR_TEMPLATE_INCONSISTENT		0x000000D1
#define ESR_SEC_VIOLATION				0x00000101
#define ESR_NOT_INITIALIZED             0x00000190
#define ESR_TOKEN_NOT_PRESENT			0x000000E0
#define ESR_TOKEN_NOT_RECOGNIZED		0x000000E1
#define ESR_ALREADY_EXIST				0x00010001
#define ESR_CONTAINER_NOT_PRESENT		0x00010002
#define ESR_NOT_EXIST	    			0x00010003
#define ESR_BUFFER_TOO_SMALL			0x00010004
#define ESR_NOT_SUPPORTED				0x00010005
#define ESR_DEVICE_ERROR				0x00000030
#define ESR_DEVICE_MEMORY				0x00000031
#define ESR_PIN_LOCKED					0x000000A4
#define ESR_PIN_INCORRECT				0x000000A0
#define ESR_MECHANISM_INVALID			0x00000070
#define ESR_DATA_LEN_RANGE				0x00000021
#define ESR_DATA_INVALID				0x00000020
#define ESR_SIGNATURE_INVALID			0x000000C0
#define ESR_DIR_NOT_FOUND				0x80100023
#define ESR_FILE_NOT_FOUND				0x80100024
#define ESR_DIR_NOT_EMPTY				0x80800001
#define ESR_DIR_EXISTS					0x80100025
#define ESR_FILE_EXISTS					0x80100026
#define ESR_PIN_LEN_RANGE               0x000000A2
#define ESR_KEY_SIZE_RANGE				0x00000062
#define ESR_MECHANISM_PARAM_INVALID		0x00000071
#define ESR_FUNCTION_CANCELED			0x00000050
#define ESR_CARD_RESET					0x80100068
#define ESR_CANT_LOCK					0x0000000A
#define ESR_NO_KEY_CONTAINER            0x80100030
#define ESR_REFERENCE_INVALID			0x000000A5

#if !defined(stdString)
#	if defined(UNICODE) || defined(_UNICODE)
#		define stdString			std::wstring
#		if !defined(WIN32)
#		define TCHAR				wchar_t
#		endif
#	else
#		define stdString			std::string
#		if !defined(WIN32)
#		define TCHAR				char
#		endif
#	endif
#endif

//Mechanism for register key import
#define CKM_IMPORTKEY                   (CKM_VENDOR_DEFINED + 0x00000001)

#if defined(linux) || defined(macintosh)
#ifndef __stdcall
	#define __stdcall
#endif

#ifndef IN
	#define IN
#endif

#ifndef OUT
	#define OUT
#endif

#ifndef MAX_PATH
	#define MAX_PATH		270
#endif

#define Sleep(x)        sleep((x+999)/1000)

typedef unsigned long			HANDLE;
typedef unsigned int			UINT;
#if defined(linux) || defined(WIN32)
typedef unsigned long			ULONG;
#else //macos 
typedef unsigned long           U_LONG;
#endif


typedef unsigned char 			UCHAR;
typedef unsigned short 			USHORT;
typedef unsigned short			WORD;
typedef unsigned char			BYTE;
typedef wchar_t				WCHAR;

#define INFINITE			0xFFFFFFFF
#define INVALID_HANDLE_VALUE		0xFFFFFFFF
#define INVALID_FILE_SIZE		0xFFFFFFF
#endif //linux

#endif//ES_TYPES_H
