#!/bin/bash
#
#EnterSafe Shuttle device mode change script
#

#test current user
TEMP_PATH=$0
if test $(id -ur) != 0; then
        echo
        echo "You should login as root user!"
        echo
        exit -1
fi
echo 
echo "Welcome config for Linux!"
echo


InputInfoplist()
{
    start=0
    end=0
    headline=0
    endline=0
    start=`cat -n /usr/local/share/ePass2003/Info.plist | grep "$FriendlyName" | head -1 | cut -f1`
    if test -z $start ; then
        cp /usr/local/share/ePass2003/Info.plist .
        cp Info.plist Info.plist.bak
        grep "ifdVendorID" Info.plist.bak > /dev/null
        if test -n $? ; then
            start=`cat -n Info.plist.bak | grep "ifdVendorID" | head -1 | cut -f1`
            end=`cat Info.plist.bak | wc -l`
            headline=$(($start+1))
            endline=$(($end-$start-1))
            head -n $headline Info.plist.bak > Info.plist
            echo	"        	<string>0x$IdVendor</string>"   >> Info.plist
	    tail -n $endline Info.plist.bak			    >> Info.plist
        else
            echo "error: edit Info.plist"
        fi

        cp Info.plist Info.plist.bak
        grep "ifdProductID" Info.plist.bak > /dev/null
        if [ $? = 0 ]; then
            start=`cat -n Info.plist.bak | grep "ifdProductID" | head -1 | cut -f1`
            end=`cat Info.plist.bak | wc -l`
            headline=$(($start+1))
            endline=$(($end-$start-1))
            head -n $headline Info.plist.bak > Info.plist
            echo	"	        <string>0x$IdProduct</string>"   >> Info.plist
            tail -n $endline Info.plist.bak			    >> Info.plist
        else
            echo "error: edit Info.plist"
        fi

        cp Info.plist Info.plist.bak
        grep "ifdFriendlyName" Info.plist.bak > /dev/null
        if [ $? = 0 ]; then
            start=`cat -n Info.plist.bak | grep "ifdFriendlyName" | head -1 | cut -f1`
            end=`cat Info.plist.bak | wc -l`
            headline=$(($start+1))
            endline=$(($end-$start-1))
            head -n $headline Info.plist.bak > Info.plist
            echo	"		<string>$FriendlyName</string>"	>> Info.plist
            tail -n $endline Info.plist.bak				>> Info.plist
        else
            echo "error: edit Info.plist"
        fi
        cp Info.plist  /usr/local/share/ePass2003/Info.plist
        rm -rf Info.plist Info.plist.bak
    fi    
}
WriteRules()
{
    num=1
    FILE="/etc/udev/rules.d/epass_token-${num}.rules"
    echo "$FILE"
    while :
    do
        if [ -e "$FILE" ]; then
	    num=$(($num+1))
            FILE="/etc/udev/rules.d/epass_token-${num}.rules"
        else
            break 
        fi
    done

    vid=${IdVendor#*x}
    strvid="$(echo $vid | tr '[:upper:]' '[:lower:]')"
    echo "SUBSYSTEM==\"usb\", ATTR{idVendor}==\"$strvid\", MODE=\"0666\"" > $FILE
    num=$(($num+1))
    FILE="/etc/udev/rules.d/epass_token-${num}.rules"
    echo "BUS==\"usb\", SYSFS{idVendor}==\"$strvid\", MODE=\"0666\"" > $FILE
}

#Revise usb hotplug script for regular user can use ePass USB Token
if [ -f /etc/hotplug/usb.agent ]; then
	declare -i start=0
        declare -i end=0
        declare -i headline=0
        declare -i endline=0
#start=`cat /etc/hotplug/usb.agent -n | grep "PRO=\`echo $PRODUCT | cut -d/ -f1\`" | head -1 | cut -f1`
	start=`cat /etc/hotplug/usb.agent -n | grep "Change mode for ePass USB Token" | head -1 | cut -f1`
        if [ $start = 0 ]; then
		cp /etc/hotplug/usb.agent /etc/hotplug/usb.agent.bak
                grep "hotplug.functions" /etc/hotplug/usb.agent > /dev/null
                if [ $? = 0 ]; then
                	start=`cat /etc/hotplug/usb.agent -n | grep "hotplug.functions" | head -1 | cut -f1`
                	end=`cat /etc/hotplug/usb.agent | wc -l`
                	headline=$start
                	endline=$end-$start
                	head -n $headline /etc/hotplug/usb.agent.bak > /etc/hotplug/usb.agent	
                        echo                                                >> /etc/hotplug/usb.agent
			echo	"#Change mode for ePass USB Token"	    >> /etc/hotplug/usb.agent 
			echo	"PRO=\`echo \$PRODUCT | cut -d/ -f1\`"      >> /etc/hotplug/usb.agent 
			echo	"if [ \$PRO == \"96e\" ]; then"	 	    >> /etc/hotplug/usb.agent 
			echo	"	while((\$i<100))"	 	    >> /etc/hotplug/usb.agent 
			echo	"	do"			 	    >> /etc/hotplug/usb.agent 
			echo	"		if [ -e \$DEVICE ]; then "  >> /etc/hotplug/usb.agent 
			echo	"			break"		    >> /etc/hotplug/usb.agent 
			echo	"		fi"			    >> /etc/hotplug/usb.agent 
			echo	"		sleep 0.01"	 	    >> /etc/hotplug/usb.agent 
			echo	"	done"			 	    >> /etc/hotplug/usb.agent 
			echo	"chmod +666 \$DEVICE"			    >> /etc/hotplug/usb.agent 
			echo	"fi"					    >> /etc/hotplug/usb.agent 
			echo						    >> /etc/hotplug/usb.agent 
                	tail -n $endline /etc/hotplug/usb.agent.bak         >> /etc/hotplug/usb.agent	
        	else
			start=`cat /etc/hotplug/usb.agent -n | grep "#!/bin/sh" | head -1 | cut -f1`
                        end=`cat /etc/hotplug/usb.agent | wc -l`
                        headline=$start+1
                        endline=$end-$start-1
                        head -n $headline /etc/hotplug/usb.agent.bak > /etc/hotplug/usb.agent
                        echo                                                >> /etc/hotplug/usb.agent
			echo	"#Change mode for ePass USB Token"	    >> /etc/hotplug/usb.agent 
			echo	"PRO=\`echo \$PRODUCT | cut -d/ -f1\`"      >> /etc/hotplug/usb.agent 
			echo	"if [ \$PRO == \"96e\" ]; then"	 	    >> /etc/hotplug/usb.agent 
			echo	"	while((\$i<100))"	 	    >> /etc/hotplug/usb.agent 
			echo	"	do"			 	    >> /etc/hotplug/usb.agent 
			echo	"		if [ -e \$DEVICE ]; then "  >> /etc/hotplug/usb.agent 
			echo	"			break"		    >> /etc/hotplug/usb.agent 
			echo	"		fi"			    >> /etc/hotplug/usb.agent 
			echo	"		sleep 0.01"	 	    >> /etc/hotplug/usb.agent 
			echo	"	done"			 	    >> /etc/hotplug/usb.agent 
			echo	"chmod +666 \$DEVICE"			    >> /etc/hotplug/usb.agent 
			echo	"fi"					    >> /etc/hotplug/usb.agent 
			echo						    >> /etc/hotplug/usb.agent 
                        tail -n $endline /etc/hotplug/usb.agent.bak                   >> /etc/hotplug/usb.agent
		fi
	fi    
else
    #echo -e "\e[1;33m skyapp exist \e[0m" //黄色
    echo "************************************************************************"
    echo "*****************We have registered the smart card as follows:          "
    echo "****IdVendor:0x096E,IdProduct:0x0807,FriendlyName:Feitian ePass2003     "
    echo "****IdVendor:0x096E,IdProduct:0x080F,FriendlyName:Feitian eJAVA Token   "
    echo "****IdVendor:0x096E,IdProduct:0x080A,FriendlyName:FT ePass2003Auto   "
    echo "************************************************************************"
    echo "do you want register New Smart card[y/N]:"
    read flag
    if [ "$flag" = y ]; then
        echo "Please input IdVendor:"
        read IdVendor
        echo "Please input IdProduct:"
        read IdProduct
        echo "Please input FriendlyName:"
        read FriendlyName
        if test -z "$IdVendor" || test -z "$IdProduct" || test -z "$FriendlyName" ; then
            echo -e "\e[1;31mIdVendor, IdProduct, FriendlyName, cannot is null!\e[0m"
            exit -1
        fi
    fi    
    if [ -d /etc/udev/rules.d/ ]; then
    	echo "SUBSYSTEM==\"usb\", ATTR{idVendor}==\"096e\", MODE=\"0666\"" > /etc/udev/rules.d/epass_token-1.rules
	echo "BUS==\"usb\", SYSFS{idVendor}==\"096e\", MODE=\"0666\"" > /etc/udev/rules.d/epass_token-2.rules
        if test -n "$IdVendor" && test -n "$IdProduct" && test -n "$FriendlyName" ; then
		WriteRules
        fi
        if service udev restart &>/dev/null ;
        then
            echo "Service udev restarted!"
        else
            echo "Please restart your computer in order for this change of udev rules to take effect"                       
        fi		
    else
        echo Please install hotplug or udev tools!!!
    fi
fi

version=`uname -r`
if [ -f /usr/local/share/ePass2003/Info.plist ]; then
    if test -n "$IdVendor" && test -n "$IdProduct" && test -n "$FriendlyName" ; then
        InputInfoplist
    fi
else
    mkdir -p /usr/local/share/ePass2003
    if [ -f ./resource/Info.plist ]; then
        cp -rf ./resource/Info.plist /usr/local/share/ePass2003
    else
        echo
        echo "install failed"
        echo "Please go to the directory where config is running"
        echo
        exit 0
    fi
    if test -n "$IdVendor" && test -n "$IdProduct" && test -n "$FriendlyName" ; then
        InputInfoplist
    fi
fi
if [ -f /usr/local/share/ePass2003/Info.plist ]; then
    echo "install successful"
fi
echo run finished!

